#!/bin/sh
d_head1='<font face=verdana size=+2>'
d_head2='</font>'
d_thead1='<center><b><font color=ffffff face=verdana>'
d_thead2='</font></b></center>'
d_col_tborder='ffffff'
d_col_theadbg='000000'
d_col_theadbg2='ffffff'
d_col_tdefbg='f0f0f0'
d_col_tgroup1bg='6060ff'
d_col_tgroup2bg='ffff40'
d_col_tgroup3bg='c0c0ff'
d_col_tgroup4bg='ffffc0'
myname=`basename $0`
read wanip < /var/run/cgiconfig2_ip
refresh=300
setup=main_cgiconfig2.cgi
state_fwrd_num=0
switch=cgiconfig2_switch.cgi
version=v0.9

export SEC_REALM="cgiconfig2"
export SEC_ACTION="view"
./sec-lib.cgi
if [ "$?" != "0" ] ; then exit 1 ; fi

#read local hosts, ips and hostname from /boot/rc.cfg to tempfile
grep -v "localhost" /etc/hosts | grep -v "#" > /tmp/cgiconfig2.hosts

while read line
do
  ip="`echo $line | cut -d" " -f1`"
  name="`echo $line | cut -d" " -f2`"
done < /tmp/cgiconfig2.hosts

leasedir=`cat /tmp/cgiconfig2.dhcpdir`

cat $leasedir/dhcpd.leases | sed 's/\"//g;' > /tmp/cgiconfig2.hosts_dhcp
while read line
do

 if [ "`echo $line | cut -d" " -f1`" = "lease" ]
 then
  ip="`echo $line | cut -d" " -f2`"
 fi
 if [ "`echo $line | cut -d" " -f1`" = "client-hostname" ]
 then
  hostname="`echo $line | cut -d" " -f2 | cut -d";" -f1`"
  echo $ip $hostname >> /tmp/cgiconfig2.hosts
 fi

done < /tmp/cgiconfig2.hosts_dhcp

hostname=`cat /tmp/cgiconfig2.rname`
FWRD_HOST_WHITE=`cat /tmp/cgiconfig2.white`
nwadress=`cat /tmp/cgiconfig2.nwadr`
idx=`cat /tmp/cgiconfig2.idx`

state_fwl_all=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$nwadress " | grep "ACCEPT" | grep "0.0.0.0/0" | grep "all"`


#parse variables...
for var in `echo "$QUERY_STRING" | tr '&' ' '`
do
 if echo "$var" | grep -v "=" > /dev/null ; then var="$var=yes" ; fi
 eval "param_$var"
done

if [ "$param_action" = "" ] ; then param_action=hosts ; fi

echo "Content-Type: text/html; charset=iso-8859-1"
echo "Cache-control: no-store"
echo "Pragma: no-cache"
echo "Expires: `date -Ru`"
echo ""
echo "
<html>
<head>
 <title>OPT_CGICONFIG2 $version</title>
 <meta HTTP-EQUIV=\"Refresh\" CONTENT=\"$refresh;url=$setup?action=$param_action&app=$param_app\">
  <style type=\"text/css\"><!--
   a { text-decoration: none }
   a:hover { color: #ff0000; text-decoration: underline}
   body { font-family: verdana}
  --></style>
</head>
<body link=0000a0 vlink=0000a0 alink=808080>
<br>
<center>
 <font face=verdana size=3>
  <table border=0 cellpadding=0 cellspaceing=0>
   <tr>
    <td> <a href=\"$myname?action=hosts\">online hosts</a> |</td>
    <td> <a href=\"$myname?action=fwl\">firewall state</a> |</td>
    <td> <a href=\"$myname?action=fwrd\">portforwarding state</a> |</td>
    <td> <a href=\"cgiconfig2.html\">readme</a></td>
   </tr>
   <tr align=center>
    <td>&nbsp;</td>
    <td>&nbsp;</td>
    <td> <a href=\"$myname?action=fwrd_adv\">custom</a></td>
    <td>&nbsp;</td>
   </tr>
  </table>
 </font>
</center>
<br><br>
"



#host state
if [ "$param_action" = "hosts" ]
then
 echo "<center>$d_head1 online hosts $d_head2<br><br>

<table border=1 cellpadding=3 cellspacing=0 bgcolor=$d_col_tdefbg bordercolor=$d_col_tborder width=512>
 <tr bgcolor=$d_col_theadbg>
  <td>$d_thead1 ip $d_thead2</td>
  <td>$d_thead1 host $d_thead2</td>
  <td>$d_thead1 state $d_thead2</td>"

 #read hosts
 while read ip name
 do
  if [ "$ip$name" != "" ]
  then
   echo " <tr>
   <td>$ip</td>
   <td>$name</td>"
   # arp auslesen und nur IP HWADRESS IFACE ausgeben
   /usr/sbin/arp -n | grep "$ip " > /tmp/cgiconfig2.arpout
   adress="" ; hwtype="" ; hwadress="" ; flag="" ; iface=""
   read adress hwtype hwadress flag iface < /tmp/cgiconfig2.arpout


   if [ "$name" = "$hostname" ]
   then
    echo "  <td><center><img src=cgiconfig2_ongreen.gif border=0 alt=\"Router\"></center></td>"
   else
    if [ "$hwadress" = "00:00:00:00:00:00" ] || [ "$hwadress" = "" ] || [ "$flag" != "C" ]
    then
     echo "  <td><center><a href=\"$switch?action=ping&host=$ip\"><img src=cgiconfig2_onred.gif border=0 alt=\"not connected\"></a></center></td>"
    else
     echo "  <td><center><a href=\"$switch?action=ping&host=$ip\"><img src=cgiconfig2_ongreen.gif border=0 alt=$hwadress></a></center></td>"
    fi
   fi
   echo " </tr>"
  fi

 done < /tmp/cgiconfig2.hosts

 echo "</table>
<form name=ping action=$switch method=get>
 <input type=hidden name=host value=all>
 <input type=submit  name=action value=\"ping all\">
</form>"
fi



#firewall state
if [ "$param_action" = "fwl" ]
then
 echo "<center> $d_head1 firewall state $d_head2 <br><br>
 <table border=1 cellpadding=3 cellspacing=0 bgcolor=$d_col_tdefbg bordercolor=$d_col_tborder width=512>
 <tr bgcolor=$d_col_theadbg>
  <td bgcolor=$d_theadbg> $d_thead1 ip $d_thead2 </td>
  <td bgcolor=$d_theadbg> $d_thead1 host $d_thead2 </td>
  <td bgcolor=$d_theadbg> $d_thead1 internet access $d_thead2 </td>
 </tr>"

 
 #read hosts from tmpfile
 while read ip name
 do
  if [ "$ip$name" != "" ]
  then
  
  #Whitelist active? 
  if [ "$FWRD_HOST_WHITE" = "yes" ]
  then
   state_fwl_fwrd=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$ip " | grep "white" | grep "0.0.0.0/0" | grep "all"`
   fwl_target="white"
  else
   state_fwl_fwrd=`/sbin/iptables -L FORWARD -n --line-numbers | grep "$ip " | grep "fdrop" | grep "0.0.0.0/0" | grep "all"`
   fwl_target="ACCEPT"
  fi

  state_inp_fwrd=`/sbin/iptables -L INPUT -n --line-numbers | grep "$ip " | grep "fdrop" | grep "0.0.0.0/0" | grep "all"`
  state_fwl=0
  if [ "$state_fwl_fwrd" = "" ] && [ "$state_inp_fwrd" = "" ] && [ "$FWRD_HOST_WHITE" = "yes" ] ; then state_fwl=1 ; fi
  if [ "$state_fwl_fwrd" = "" ] && [ "$state_inp_fwrd" != "" ] && [ "$FWRD_HOST_WHITE" = "yes" ] ; then state_fwl=2 ; fi
  if [ "$FWRD_HOST_WHITE" = "no" ] && [ "$state_inp_fwrd" = "" ] && [ "$state_fwl_fwrd" != "" ] ; then state_fwl=1 ; fi
  if [ "$FWRD_HOST_WHITE" = "no" ] && [ "$state_inp_fwrd" != "" ] && [ "$state_fwl_fwrd" != "" ] ; then state_fwl=2 ; fi
  echo " <tr>
  <td>$ip</td>
  <td>$name</td>
  <td>
   <center>"
   
  if [ "$name" = "$hostname" ]
  then
    echo "     <img src=cgiconfig2_ongreen.gif border=0>" 
  else
    if [ "$state_fwl" = "2" ]
    then
      echo "     <a href=\"$switch?referrer=fwl&fwl_mode=2&fwl_host=$ip\"><img src=cgiconfig2_onred.gif border=0 alt=\"Internet-Access DENIED\"></a>"
    else
      echo "     <a href=\"$switch?referrer=fwl&fwl_mode=2&fwl_host=$ip\"><img src=cgiconfig2_offred.gif border=0></a>"
    fi
    if [ "$state_fwl" = "1" ]
    then
      echo "     <a href=\"$switch?referrer=fwl&fwl_mode=1&fwl_host=$ip\"><img src=cgiconfig2_onyellow.gif border=0 alt=\"Internet-Access with Proxy only\"></a>"
    else
      echo "     <a href=\"$switch?referrer=fwl&fwl_mode=1&fwl_host=$ip\"><img src=cgiconfig2_offyellow.gif border=0></a>"
    fi
    if [ "$state_fwl" = "0" ]
    then
      echo "     <a href=\"$switch?referrer=fwl&fwl_mode=0&fwl_host=$ip\"><img src=cgiconfig2_ongreen.gif border=0 alt=\"Internet-Access GRANTED\"></a>"
    else
      echo "     <a href=\"$switch?referrer=fwl&fwl_mode=0&fwl_host=$ip\"><img src=cgiconfig2_offgreen.gif border=0></a>"
    fi
  fi
  echo "    </center>
  </td>"
 fi
done < /tmp/cgiconfig2.hosts
 echo "</tr>
 <tr>
 <form name=fwl_custom method=get action=$switch>
 <input type=hidden name=referrer value=fwl>
 <td><input type=text name=fwl_host length=15 maxlength=15 value=192.168.0.></td>
 <td><i>custom ip</i></td>
 <td><center>
  <select name=fwl_mode>
   <option value=0 selected >grant router access&forwarding<br>
   <option value=1>only deny forwarding<br>
   <option value=2>deny router access&forwarding<br>
  </select>
  <input type=submit value=execute></center></td>
 </form>
</tr>"
echo "</table>"
fi


if [ "$param_action" = "fwrd" ]
then
 echo "<center> $d_head1 port forwarding from base.txt $d_head2 <br><br>
 <table border=1 cellpadding=3 cellspacing=0 bgcolor=$d_col_tdefbg bordercolor=$d_col_tborder width=512>
 <tr bgcolor=$d_col_theadbg>
  <td bgcolor=$d_theadbg> $d_thead1 port(s) $d_thead2 </td>
  <td bgcolor=$d_theadbg> $d_thead1 ip $d_thead2 </td>
  <td bgcolor=$d_theadbg> $d_thead1 protocol $d_thead2 </td>
  <td bgcolor=$d_theadbg> $d_thead1 Status $d_thead2 </td>
 </tr>"
 
while [ "$idx" != "0" ]
do
 fwrd_s=`cat /boot/rc.cfg | grep "PORTFW_$idx\_" | grep "SOURCE" | sed "s/PORTFW_$idx\_SOURCE='//; s/'//"`
 tmp_s=`echo $fwrd_s | sed "s/-/:/"`
 fwrd_t=`cat /boot/rc.cfg | grep "PORTFW_$idx\_" | grep "TARGET" | sed "s/PORTFW_$idx\_TARGET='//; s/:$fwrd_s//; s/'//"`
 fwrd_p=`cat /boot/rc.cfg | grep "PORTFW_$idx\_" | grep "PROTOCOL" | sed "s/PORTFW_$idx\_PROTOCOL='//; s/'//"`
 echo "<tr>
 <td>$fwrd_s</td>
 <td>$fwrd_t</td>
 <td>$fwrd_p</td>
 <td>
 <center>"
 state_pfwc=0
 state_pfw=`/sbin/iptables -L FORWARD -n | grep "$fwrd_p" | grep "$fwrd_t" | grep "ACCEPT" | grep "0.0.0.0/0" | grep "$tmp_s"`
 if [ "$state_pfw" != "" ] ; then state_pfwc=2 ; fi
 if [ "$state_pfwc" = "0" ]
 then
  echo "<a href=\"$switch?referrer=fwrd&fwrd_mode=0&port_fwrd=$tmp_s&ip_fwrd=$fwrd_t&prot_fwrd=$fwrd_p\"><img src=cgiconfig2_onred.gif border=0 alt=$idx></a>"
 else
  echo "<a href=\"$switch?referrer=fwrd&fwrd_mode=0&port_fwrd=$tmp_s&ip_fwrd=$fwrd_t&prot_fwrd=$fwrd_p\"><img src=cgiconfig2_offred.gif border=0></a>"
 fi
 if [ "$state_pfwc" = "2" ]
 then
  echo "<a href=\"$switch?referrer=fwrd&fwrd_mode=1&port_fwrd=$tmp_s&ip_fwrd=$fwrd_t&prot_fwrd=$fwrd_p\"><img src=cgiconfig2_ongreen.gif border=0 alt=$idx></a>"
 else
  echo "<a href=\"$switch?referrer=fwrd&fwrd_mode=1&port_fwrd=$tmp_s&ip_fwrd=$fwrd_t&prot_fwrd=$fwrd_p\"><img src=cgiconfig2_offgreen.gif border=0></a>"
 fi

echo "</center></td></tr>"
 idx=`expr $idx - 1`
done
echo "</table>"
fi


if [ "$param_action" = "fwrd_adv" ]
then
 echo "<center> $d_head1 advanced Portforwarding $d_head2 <br><br>
 <table border=1 cellpadding=3 cellspacing=0 bgcolor=$d_col_tdefbg bordercolor=$d_col_tborder width=700>
 <tr bgcolor=$d_col_theadbg>
  <td bgcolor=$d_theadbg> $d_thead1 no. $d_thead2 </td>
  <td bgcolor=$d_theadbg> $d_thead1 Target $d_thead2 </td>
  <td bgcolor=$d_theadbg> $d_thead1 Protocol $d_thead2 </td>
  <td bgcolor=$d_theadbg> $d_thead1 Source $d_thead2 </td>
  <td bgcolor=$d_theadbg> $d_thead1 Destination $d_thead2 </td>
  <td bgcolor=$d_theadbg> $d_thead1 Port(s) $d_thead2 </td>
  <td bgcolor=$d_theadbg> $d_thead1 X $d_thead2 </td>
 </tr>"


#read number of Portforwarding-rules

if [ -f /tmp/cgiconfig2.fwrd ] ; then rm /tmp/cgiconfig2.fwrd ; fi
if [ -f /tmp/cgiconfig2.fwrdnum ] ; then rm /tmp/cgiconfig2.fwrdnum ; fi

idxb=0
pfw_hits=0
idxt=1
total_num=`/sbin/iptables -L FORWARD -n --line-numbers | grep "^$idxt "`


#read number of all Rules in FORWARD
while [ "$total_num" != "" ]
do
 idxt=`expr $idxt + 1`
 total_num=`/sbin/iptables -L FORWARD -n --line-numbers | grep "^$idxt "`
done
idxt=`expr $idxt - 1`

#read Forwarding-Rules from Forward
while [ "$idxb" != "$idxt" ]
do
 tmp_num=`/sbin/iptables -L FORWARD -n --line-numbers | grep -v "all" | grep "ACCEPT" | grep "^$idxb " | sed "s/[ACCEPT].*//"`
 if [ "$tmp_num" != "" ]
 then
   hit=`expr $pfw_hits + 1`
   echo $tmp_num >> /tmp/cgiconfig2.fwrdnum
   pfw_last_hit=`expr $idxb + 1`
  fi
 idxb=`expr $idxb + 1`
done

while read pfw_num
do
 state_adv_pfw=`/sbin/iptables -L FORWARD -n --line-numbers | grep -v "all" | grep "ACCEPT" | grep "^$pfw_num "`
 echo $state_adv_pfw >> /tmp/cgiconfig2.fwrd
done < /tmp/cgiconfig2.fwrdnum

pfw_num=""; pfw_stat=""; pfw_prot1=""; spacer=""; pfw_src=""; pfw_des=""; pfw_prot2=""; pfw_targ=""

while read pfw_num pfw_stat pfw_prot1 spacer pfw_src pfw_des pfw_prot2 pfw_targ
do

pfw_ftarg=`echo $pfw_targ | sed "s/dpts*://"`
pre_num=`/sbin/iptables -t nat -L PREROUTING -n --line-numbers | grep "$pfw_prot1 " | grep "$pfw_ftarg" | grep "$pfw_des" | sed "s/[DNAT].*//"`

echo "<tr>
 <td> $pfw_num </td>
 <td> $pfw_stat </td>
 <td> $pfw_prot1 </td>
 <td> $pfw_src </td>
 <td> $pfw_des </td>
 <td> $pfw_ftarg ($pfw_prot2) </td>
 <td> <a href=\"$switch?referrer=fwrd_adv&action=del_rule&fwrd_rem=$pfw_num&pre_rem=$pre_num\"><img src=cgiconfig2_del.gif border=0 alt=\"DELETE Rule\"></a></td>
 </tr>"
done < /tmp/cgiconfig2.fwrd
echo "</table><br><br>"

#Save?
if [ -f /tmp/cgiconfig2.save ]
then
  echo "<font color=#FF0000><center><b>Custom settings are used after reboot..</b></center><br></font>"
  echo "<b><i><a href=\"$switch?referrer=fwrd_adv&action=save&state=no\">Discard after reboot and delete save-file</a></b></center><br></i>"
else
  echo "<font color=#FF0000><center><b>Custom settings will be discarded after reboot..</b></center><br></font>"
  echo "<br><i><center><b><a href=\"$switch?referrer=fwrd_adv&action=save&state=yes\">Use this Configuration after reboot</a></b><br></i>"
fi


echo "<br><br><center> $d_head1 add custom Portforwarding $d_head2 <br><br>
 <table border=1 cellpadding=3 cellspacing=0 bgcolor=$d_col_tdefbg bordercolor=$d_col_tborder width=650>
 <tr bgcolor=$d_col_theadbg>
  <td bgcolor=$d_theadbg> $d_thead1 Protocol $d_thead2 </td>
  <td bgcolor=$d_theadbg> $d_thead1 Destination $d_thead2 </td>
  <td bgcolor=$d_theadbg> $d_thead1 Port(s) $d_thead2 </td>
  <td bgcolor=$d_theadbg> </td>
 </tr>

 <tr>
  <form name=fwrd_custom method=get action=$switch>
  <input type=hidden name=referrer value=fwrd_adv>
  <input type=hidden name=pfw_add value=\"$pfw_last_hit\">
  <td><select name=fwrd_prot>
    <option value=tcp selected>TCP<br>
    <option value=udp>UDP<br>
  </select></td>
  <td><input type=text name=fwrd_host length=15 maxlength=15 value=192.168.0.></td>
  <td><input type=text name=fwrd_port length=20 maxlength=20 value=0></td>
  <td><input type=submit name=action value=ADD></center></td>
  </form>
 </tr>"
echo "</table>"
fi


if [ "$param_html" != "0" ]
then
 echo "</center>
 <br><br><br><br>
 <p align=right>
 <font face=verdana size=-2>
 Written by <a href=\"mailto:bosborros@gmx.net\">Benjamin Hering</a><br>
 $version <a href=\"http://www.fli4l.de\" target=\"_blank\">www.fli4l.de</a></p>
 </body></html>"
fi